/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old.views;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.core.io.preferences.PermissionDirection;
import com.aptana.ide.core.io.preferences.PreferenceUtils;
import com.aptana.ide.syncing.core.old.ConnectionPointSyncPair;
import com.aptana.ide.syncing.core.old.ILogger;
import com.aptana.ide.syncing.core.old.ISyncEventHandler;
import com.aptana.ide.syncing.core.old.ISyncResource;
import com.aptana.ide.syncing.core.old.SyncFile;
import com.aptana.ide.syncing.core.old.SyncFolder;
import com.aptana.ide.syncing.core.old.SyncJob;
import com.aptana.ide.syncing.core.old.SyncModelBuilder;
import com.aptana.ide.syncing.core.old.Synchronizer;
import com.aptana.ide.syncing.core.old.VirtualFileSyncPair;
import com.aptana.ide.syncing.core.old.handlers.SyncEventHandlerAdapterWithProgressMonitor;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.internal.SyncUtils;
import com.aptana.ide.syncing.ui.old.SyncingConsole;
import com.aptana.ide.syncing.ui.old.views.DirectionToolBar;
import com.aptana.ide.syncing.ui.old.views.Messages;
import com.aptana.ide.syncing.ui.old.views.OptionsToolBar;
import com.aptana.ide.syncing.ui.old.views.SmartSyncEventManager;
import com.aptana.ide.syncing.ui.old.views.SmartSyncViewer;
import com.aptana.ide.syncing.ui.old.views.SyncExporter;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.navigator.RemoteNavigatorView;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.ftp.preferences.UpdatePermissionsComposite;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SearchComposite;
import java.io.File;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public class SmartSyncDialog
extends TitleAreaDialog
implements SelectionListener,
ModifyListener,
DirectionToolBar.Client,
OptionsToolBar.Client,
SyncJob.Client,
SearchComposite.Client {
    private static final String ICON = "icons/full/elcl16/arrow_up_down.png";
    private static final String ICON_UPDATE = "icons/full/obj16/sync.png";
    private static final String ICON_SKIP = "icons/full/obj16/skip.png";
    private static final String ICON_DELETE = "icons/full/obj16/delete.png";
    private static final String IMAGE_LOCAL_SITE = "icons/full/wizban/local_site.png";
    private static final String IMAGE_REMOTE_SITE = "icons/full/wizban/remote_site.png";
    private static final String CLOSE_ICON = "icons/full/elcl16/close.png";
    private static final String LOG_EXPORT_DIRECTORY = "logExportDirectory";
    private static final String CLOSE_WHEN_DONE = "com.aptana.ide.syncing.views.CLOSE_WHEN_DONE";
    private static final String COMPARE_IN_BACKGROUND = "COMPARE_IN_BACKGROUND";
    private static final String USE_CRC = "USE_CRC";
    private static final String SKIPPED_LABEL = Messages.SmartSyncDialog_NumFilesToSkip;
    private static final String UPDATED_LABEL = Messages.SmartSyncDialog_NumFilesToUpdate;
    private static final String DELETED_LABEL = Messages.SmartSyncDialog_NumFilesToDelete;
    private static final String SYNC_LABEL = Messages.SmartSyncDialog_Comparing;
    private Composite dialogArea;
    private Label updatedLabel;
    private Label skippedLabel;
    private Label deletedLabel;
    private Font boldFont;
    private SmartSyncViewer syncViewer;
    private Button startSync;
    private Button cancel;
    private Button closeWhenDone;
    private Button deleteRemoteFiles;
    private Button deleteLocalFiles;
    private Button useCrc;
    private Button syncInBackground;
    private UpdatePermissionsComposite uploadPermComposite;
    private UpdatePermissionsComposite downloadPermComposite;
    private Composite loadingComp;
    private Label loadingLabel;
    private DirectionToolBar directionBar;
    private OptionsToolBar optionsBar;
    private SyncFolder root;
    private String end1;
    private String end2;
    private Synchronizer syncer;
    private IFileStore source;
    private IFileStore dest;
    private IConnectionPoint sourceConnectionPoint;
    private IConnectionPoint destConnectionPoint;
    private ISyncEventHandler handler;
    private boolean compareInBackground;
    private Composite swappable;
    private Composite errorComp;
    private Label errorLabel;
    private Link retryLink;
    private Composite synced;
    private Label syncedIcon;
    private Label syncedText;
    private SyncJob syncJob;
    private int skipped;
    private Job buildSmartSync;
    private IFileStore[] sourceFilesToBeSynced;
    private IFileStore[] destFilesToBeSynced;
    private Image titleImage;
    private Button left_arrow;
    private Button right_arrow;
    private Label sync_label;
    private GridData filterLayoutData;
    private CLabel filterLabel;
    private Composite filterComp;
    private ViewerFilter viewerFilter;
    private String searchText;
    private Button saveLog;
    private Pattern searchPattern;
    private SearchComposite searchComposite;

    public SmartSyncDialog(Shell parent, IConnectionPoint sourceManager, IConnectionPoint destManager, IFileStore source, IFileStore dest, String end1, String end2) {
        super(parent);
        this.sourceConnectionPoint = sourceManager;
        this.destConnectionPoint = destManager;
        this.setShellStyle(SmartSyncDialog.getDefaultOrientation() | 0x10 | 0x10000 | 0x860);
        this.source = source;
        this.dest = dest;
        this.end1 = end1;
        this.end2 = end2;
        this.compareInBackground = SmartSyncDialog.getCoreUIPreferenceStore().getBoolean(COMPARE_IN_BACKGROUND);
        this.syncer = new Synchronizer(SmartSyncDialog.getCoreUIPreferenceStore().getBoolean(USE_CRC), 1000);
        if (source != null) {
            this.syncer.setClientFileManager(sourceManager);
            this.syncer.setClientFileRoot(source);
        }
        if (dest != null) {
            this.syncer.setServerFileManager(destManager);
            this.syncer.setServerFileRoot(dest);
        }
        this.syncer.setLogger(new ILogger(){

            public void logWarning(String message, Throwable th) {
                SyncingConsole.println(message);
            }

            public void logInfo(String message, Throwable th) {
                SyncingConsole.println(message);
            }

            public void logError(String message, Throwable th) {
                SyncingConsole.println(message);
            }
        });
    }

    public SmartSyncDialog(Shell parent, ConnectionPointSyncPair conf, IFileStore[] sourceFilesToBeSynced, IFileStore[] destFilesToBeSynced) throws CoreException {
        this(parent, conf.getSourceFileManager(), conf.getDestinationFileManager(), conf.getSourceFileManager().getRoot(), conf.getDestinationFileManager().getRoot(), conf.getSourceFileManager().getName(), conf.getDestinationFileManager().getName());
        IPath path;
        this.syncer.setClientFileManager(conf.getSourceFileManager());
        this.syncer.setServerFileManager(conf.getDestinationFileManager());
        this.sourceConnectionPoint = conf.getSourceFileManager();
        this.destConnectionPoint = conf.getDestinationFileManager();
        this.syncer.setClientFileRoot(this.sourceConnectionPoint.getRoot());
        this.syncer.setServerFileRoot(this.destConnectionPoint.getRoot());
        if (sourceFilesToBeSynced == null || sourceFilesToBeSynced.length == 0) {
            this.sourceFilesToBeSynced = null;
        } else {
            this.sourceFilesToBeSynced = sourceFilesToBeSynced;
            if (sourceFilesToBeSynced.length == 1) {
                path = EFSUtils.getRelativePath((IConnectionPoint)this.sourceConnectionPoint, (IFileStore)sourceFilesToBeSynced[0]);
                if (path == null || Path.EMPTY.equals((Object)path)) {
                    this.sourceFilesToBeSynced = null;
                } else {
                    IFileStore fileStore;
                    this.end1 = MessageFormat.format("{0} ({1})", this.end1, path);
                    if ((destFilesToBeSynced == null || destFilesToBeSynced.length == 0) && Utils.exists((IAdaptable)(fileStore = this.destConnectionPoint.getRoot().getFileStore(path)))) {
                        this.destFilesToBeSynced = new IFileStore[]{fileStore};
                        return;
                    }
                }
            }
        }
        if (destFilesToBeSynced == null || destFilesToBeSynced.length == 0) {
            this.destFilesToBeSynced = null;
        } else {
            this.destFilesToBeSynced = destFilesToBeSynced;
            if (destFilesToBeSynced.length == 1) {
                path = EFSUtils.getRelativePath((IConnectionPoint)this.destConnectionPoint, (IFileStore)destFilesToBeSynced[0]);
                if (path == null || Path.EMPTY.equals((Object)path)) {
                    this.destFilesToBeSynced = null;
                } else {
                    this.end2 = MessageFormat.format("{0} ({1})", this.end2, path);
                }
            }
        }
    }

    private void disconnectAndClose() {
        Job disconnectJob = new Job("disconnect the sync file manager"){

            protected IStatus run(IProgressMonitor monitor) {
                if (SmartSyncDialog.this.buildSmartSync != null) {
                    if (SmartSyncDialog.this.buildSmartSync.getResult() == null) {
                        SmartSyncDialog.this.buildSmartSync.cancel();
                    }
                    try {
                        SmartSyncDialog.this.buildSmartSync.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (SmartSyncDialog.this.syncJob != null) {
                    if (SmartSyncDialog.this.syncJob.getResult() == null) {
                        SmartSyncDialog.this.syncJob.cancel();
                    }
                    try {
                        SmartSyncDialog.this.syncJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                SmartSyncDialog.this.syncer.disconnect();
                return Status.OK_STATUS;
            }
        };
        disconnectJob.setPriority(10);
        try {
            disconnectJob.setSystem(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        disconnectJob.schedule();
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SmartSyncDialog_Title);
        newShell.setImage(SyncingUIPlugin.getImage(ICON));
    }

    private Composite createDirectionOptions(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.optionsBar = new OptionsToolBar(main, this);
        this.optionsBar.setPresentationType(SmartSyncDialog.getPresentationTypePref());
        this.optionsBar.setShowDatesSelected(SmartSyncDialog.getShowModificationTimePref());
        this.optionsBar.setEnabled(false);
        this.directionBar = new DirectionToolBar(main, this, this.end1, this.end2);
        this.directionBar.setSelection(SmartSyncDialog.getDirectionPref());
        this.directionBar.setEnabled(false);
        GridData gridData = new GridData(0x1000008, 0x1000000, true, false);
        this.directionBar.getControl().setLayoutData((Object)gridData);
        return main;
    }

    private Composite createHeader(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite description = new Composite(top, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        description.setLayout((Layout)layout);
        description.setLayoutData((Object)new GridData(4, 4, true, true));
        Label descriptionLabel = new Label(description, 16384);
        FontData[] data = SWTUtils.resizeFont((Font)top.getFont(), (int)4);
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(1);
            ++i;
        }
        final Font headerFont = new Font((Device)top.getDisplay(), data);
        descriptionLabel.setFont(headerFont);
        descriptionLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                headerFont.dispose();
            }
        });
        Composite endpoints = new Composite(description, 0);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        layout.verticalSpacing = 0;
        endpoints.setLayout((Layout)layout);
        endpoints.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Label local_site = new Label(endpoints, 512);
        local_site.setImage(SyncingUIPlugin.getImage(IMAGE_LOCAL_SITE));
        GridData gridData = new GridData(0x1000000, 0x1000000, false, true);
        local_site.setLayoutData((Object)gridData);
        Composite directions = new Composite(endpoints, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginTop = 0;
        directions.setLayout((Layout)layout);
        gridData = new GridData(0x1000000, 0x1000000, false, true);
        directions.setLayoutData((Object)gridData);
        this.left_arrow = new Button(directions, 2);
        this.left_arrow.setImage(SyncingUIPlugin.getImage("icons/full/wizban/sync_arrow_left.png"));
        gridData = new GridData(131072, 0x1000000, false, true);
        this.left_arrow.setLayoutData((Object)gridData);
        this.left_arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SmartSyncDialog.this.left_arrow.getSelection()) {
                    SmartSyncDialog.this.directionBar.setSelection(1);
                } else if (SmartSyncDialog.this.right_arrow.getSelection()) {
                    SmartSyncDialog.this.directionBar.setSelection(0);
                } else {
                    SmartSyncDialog.this.directionBar.setSelection(2);
                }
                SmartSyncDialog.this.updateSyncArrows(SmartSyncDialog.this.directionBar.getSelection());
                SmartSyncDialog.this.load(false);
            }
        });
        this.right_arrow = new Button(directions, 2);
        this.right_arrow.setImage(SyncingUIPlugin.getImage("icons/full/wizban/sync_arrow_right.png"));
        gridData = new GridData(16384, 0x1000000, false, true);
        this.right_arrow.setLayoutData((Object)gridData);
        this.right_arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SmartSyncDialog.this.right_arrow.getSelection()) {
                    SmartSyncDialog.this.directionBar.setSelection(2);
                } else if (SmartSyncDialog.this.left_arrow.getSelection()) {
                    SmartSyncDialog.this.directionBar.setSelection(0);
                } else {
                    SmartSyncDialog.this.directionBar.setSelection(1);
                }
                SmartSyncDialog.this.updateSyncArrows(SmartSyncDialog.this.directionBar.getSelection());
                SmartSyncDialog.this.load(false);
            }
        });
        Label remote_site = new Label(endpoints, 0x1000200);
        remote_site.setImage(SyncingUIPlugin.getImage(IMAGE_REMOTE_SITE));
        gridData = new GridData(0x1000000, 0x1000000, false, true);
        remote_site.setLayoutData((Object)gridData);
        if (this.sourceFilesToBeSynced == null || this.sourceFilesToBeSynced.length <= 1) {
            Label end1Label = new Label(endpoints, 0x1000000);
            end1Label.setText(FileUtil.compressPath((String)this.source.toString(), (int)30));
            end1Label.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        } else {
            Composite end1Comp = new Composite(endpoints, 0);
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            end1Comp.setLayout((Layout)layout);
            end1Comp.setLayoutData((Object)new GridData(4, 4, false, false));
            Label end1Label = new Label(end1Comp, 0x1000000);
            end1Label.setText(FileUtil.compressPath((String)this.source.toString(), (int)30));
            end1Label.setLayoutData((Object)new GridData(0x1000000, 256, false, false));
            Label end1Extra = new Label(end1Comp, 0);
            end1Extra.setText(Messages.SmartSyncDialog_LBL_MultipleFiles);
            end1Extra.setLayoutData((Object)new GridData(1, 4, true, false));
            end1Extra.setToolTipText(null);
            new LabelToolTip((Control)end1Extra, this.sourceConnectionPoint, this.sourceFilesToBeSynced);
        }
        this.sync_label = new Label(endpoints, 0x1000200);
        gridData = new GridData(0x1000000, 0x1000000, false, true);
        gridData.widthHint = 150;
        this.sync_label.setLayoutData((Object)gridData);
        this.sync_label.setText("");
        if (this.destFilesToBeSynced == null || this.destFilesToBeSynced.length <= 1) {
            Label end2Label = new Label(endpoints, 0x1000000);
            end2Label.setText(FileUtil.compressPath((String)this.dest.toString(), (int)30));
            end2Label.setLayoutData((Object)new GridData(4, 4, true, false));
        } else {
            Composite end2Comp = new Composite(endpoints, 0);
            end2Comp.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
            end2Comp.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            Label end2Label = new Label(end2Comp, 0x1000000);
            end2Label.setText(FileUtil.compressPath((String)this.dest.toString(), (int)30));
            end2Label.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
            Label end2Extra = new Label(end2Comp, 0);
            end2Extra.setText(Messages.SmartSyncDialog_LBL_MultipleFiles);
            end2Extra.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, false).create());
            end2Extra.setToolTipText(null);
            new LabelToolTip((Control)end2Extra, this.destConnectionPoint, this.destFilesToBeSynced);
        }
        Label shadow_sep_h = new Label(endpoints, 262);
        gridData = new GridData(4, 0x1000000, false, true);
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 15;
        shadow_sep_h.setLayoutData((Object)gridData);
        Composite status = new Composite(description, 0);
        layout = new GridLayout(7, false);
        layout.marginWidth = 40;
        layout.marginTop = 12;
        status.setLayout((Layout)layout);
        status.setLayoutData((Object)new GridData(4, 4, true, true));
        Label updatedSymbol = new Label(status, 512);
        updatedSymbol.setImage(SyncingUIPlugin.getImage(ICON_UPDATE));
        this.updatedLabel = new Label(status, 16384);
        this.updatedLabel.setText(UPDATED_LABEL);
        Label skippedSymbol = new Label(status, 512);
        skippedSymbol.setImage(SyncingUIPlugin.getImage(ICON_SKIP));
        this.skippedLabel = new Label(status, 16384);
        this.skippedLabel.setText(SKIPPED_LABEL);
        Label deletedSymbol = new Label(status, 512);
        deletedSymbol.setImage(SyncingUIPlugin.getImage(ICON_DELETE));
        this.deletedLabel = new Label(status, 16384);
        this.deletedLabel.setText(DELETED_LABEL);
        this.searchComposite = this.createSearchComposite(status);
        this.filterComp = this.createFilterComposite(status);
        return top;
    }

    private SearchComposite createSearchComposite(Composite myComposite) {
        SearchComposite search = new SearchComposite(myComposite, (SearchComposite.Client)this);
        search.setSearchOnEnter(false);
        search.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        search.setInitialText(Messages.SmartSyncDialog_searchText);
        return search;
    }

    private Composite createFilterComposite(Composite myComposite) {
        Composite filter = new Composite(myComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 2;
        filter.setLayout((Layout)gridLayout);
        this.filterLayoutData = new GridData(4, 0x1000000, true, false);
        this.filterLayoutData.exclude = true;
        filter.setLayoutData((Object)this.filterLayoutData);
        this.filterLabel = new CLabel(filter, 16384);
        this.filterLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar toolBar = new ToolBar(filter, 0x800000);
        toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(SyncingUIPlugin.getImage(CLOSE_ICON));
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SmartSyncDialog.this.removeFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return filter;
    }

    protected void hideFilterLable() {
        this.filterLayoutData.exclude = true;
        this.filterComp.setVisible(false);
        this.filterComp.getParent().layout();
    }

    protected void showFilterLabel(Image image, String text) {
        this.filterLabel.setImage(image);
        this.filterLabel.setText(text);
        this.filterLayoutData.exclude = false;
        this.filterComp.setVisible(true);
        this.filterComp.getParent().layout();
    }

    protected void removeFilter() {
        this.hideFilterLable();
    }

    private Composite createDeleteOptions(Composite parent) {
        Composite deletes = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        deletes.setLayout((Layout)layout);
        deletes.setLayoutData((Object)new GridData(4, 4, false, false));
        this.deleteLocalFiles = new Button(deletes, 32);
        this.deleteLocalFiles.setText(String.valueOf(Messages.SmartSyncDialog_DeleteExtra) + "'" + this.end1 + "'");
        this.deleteLocalFiles.setToolTipText(String.valueOf(Messages.SmartSyncDialog_DeleteExtraTooltip) + this.end1 + "'");
        this.deleteLocalFiles.setSelection(SmartSyncDialog.getDeleteLocalPreference());
        this.deleteLocalFiles.setLayoutData((Object)new GridData(4, 4, false, false));
        this.deleteLocalFiles.addSelectionListener((SelectionListener)this);
        this.deleteRemoteFiles = new Button(deletes, 32);
        this.deleteRemoteFiles.setText(String.valueOf(Messages.SmartSyncDialog_DeleteExtra) + "'" + this.end2 + "'");
        this.deleteRemoteFiles.setToolTipText(String.valueOf(Messages.SmartSyncDialog_DeleteExtraTooltip) + "'" + this.end2 + "'");
        this.deleteRemoteFiles.setSelection(SmartSyncDialog.getDeleteRemotePreference());
        this.deleteRemoteFiles.setLayoutData((Object)new GridData(4, 4, false, false));
        this.deleteRemoteFiles.addSelectionListener((SelectionListener)this);
        this.closeWhenDone = new Button(deletes, 32);
        this.closeWhenDone.setText(Messages.SmartSyncDialog_CloseWhenDone);
        this.closeWhenDone.setLayoutData((Object)new GridData(4, 4, true, false));
        this.closeWhenDone.setSelection(SmartSyncDialog.getSyncingPreferenceStore().getBoolean(CLOSE_WHEN_DONE));
        this.closeWhenDone.addSelectionListener((SelectionListener)this);
        return deletes;
    }

    private Composite createFooter(Composite parent) {
        Composite footer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        footer.setLayout((Layout)layout);
        footer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createDeleteOptions(footer);
        this.createDirectionOptions(footer);
        return footer;
    }

    private Composite createAdvancedSection(Composite parent) {
        Composite advanced = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 8;
        advanced.setLayout((Layout)layout);
        advanced.setLayoutData((Object)new GridData(4, 4, true, false));
        final Cursor hand = new Cursor((Device)advanced.getDisplay(), 21);
        final Font boldFont = new Font((Device)advanced.getDisplay(), SWTUtils.boldFont((Font)advanced.getFont()));
        advanced.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (hand != null && !hand.isDisposed()) {
                    hand.dispose();
                }
                if (boldFont != null && !boldFont.isDisposed()) {
                    boldFont.dispose();
                }
            }
        });
        final Label advancedIcon = new Label(advanced, 16384);
        advancedIcon.setImage(SyncingUIPlugin.getImage("icons/full/obj16/maximize.png"));
        advancedIcon.setCursor(hand);
        advancedIcon.setLayoutData((Object)new GridData(4, 4, false, false));
        Label advancedLabel = new Label(advanced, 16384);
        advancedLabel.setText(Messages.SmartSyncDialog_AdvancedOptions);
        advancedLabel.setCursor(hand);
        advancedLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        advancedLabel.setFont(boldFont);
        final Composite advancedOptions = new Composite(advanced, 0);
        layout = new GridLayout();
        layout.marginLeft = 15;
        advancedOptions.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        gridData.exclude = true;
        advancedOptions.setLayoutData((Object)gridData);
        advancedOptions.setVisible(false);
        MouseAdapter expander = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (advancedOptions.isVisible()) {
                    advancedOptions.setVisible(false);
                    advancedIcon.setImage(SyncingUIPlugin.getImage("icons/full/obj16/maximize.png"));
                    ((GridData)advancedOptions.getLayoutData()).exclude = true;
                } else {
                    advancedOptions.setVisible(true);
                    advancedIcon.setImage(SyncingUIPlugin.getImage("icons/full/obj16/minimize.png"));
                    ((GridData)advancedOptions.getLayoutData()).exclude = false;
                }
                SmartSyncDialog.this.dialogArea.layout(true, true);
            }
        };
        advancedIcon.addMouseListener((MouseListener)expander);
        advancedLabel.addMouseListener((MouseListener)expander);
        this.useCrc = new Button(advancedOptions, 32);
        this.useCrc.setText(Messages.SmartSyncDialog_UseCrc);
        this.useCrc.setSelection(SmartSyncDialog.getCoreUIPreferenceStore().getBoolean(USE_CRC));
        this.useCrc.addSelectionListener((SelectionListener)this);
        this.syncInBackground = new Button(advancedOptions, 32);
        this.syncInBackground.setText(Messages.SmartSyncDialog_SyncInBackground);
        this.syncInBackground.setSelection(SmartSyncDialog.getCoreUIPreferenceStore().getBoolean(COMPARE_IN_BACKGROUND));
        this.syncInBackground.addSelectionListener((SelectionListener)this);
        Group group = new Group(advancedOptions, 0);
        group.setText(Messages.SmartSyncDialog_LBL_PermforUploads);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.uploadPermComposite = new UpdatePermissionsComposite((Composite)group, PermissionDirection.UPLOAD);
        this.uploadPermComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        group = new Group(advancedOptions, 0);
        group.setText(Messages.SmartSyncDialog_LBL_PermForDownloads);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.downloadPermComposite = new UpdatePermissionsComposite((Composite)group, PermissionDirection.DOWNLOAD);
        this.downloadPermComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        return advanced;
    }

    private Composite createMainSection(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        this.swappable = this.createTable(main);
        this.createFooter(main);
        return main;
    }

    private Composite createErrorSection(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setBackgroundMode(1);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.exclude = true;
        main.setLayoutData((Object)gridData);
        this.errorLabel = new Label(main, 0x1000040);
        final Font font = new Font((Device)main.getDisplay(), "Arial", 12, 0);
        this.errorLabel.setFont(font);
        this.errorLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.errorLabel.setForeground(main.getDisplay().getSystemColor(15));
        this.errorLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.retryLink = new Link(main, 0);
        this.retryLink.setText("<a>" + Messages.SmartSyncDialog_Retry + "</a>");
        this.retryLink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.retryLink.addSelectionListener((SelectionListener)this);
        main.setVisible(false);
        return main;
    }

    private void updateStatLabels() {
        ISyncResource[] resources;
        int deleted = 0;
        int updated = 0;
        int skipped = 0;
        int selection = this.directionBar.getSelection();
        ISyncResource[] iSyncResourceArray = resources = this.syncViewer.getCurrentResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource resource = iSyncResourceArray[n2];
            if (resource.isSkipped()) {
                ++skipped;
            } else if ((selection == 0 || selection == 2) && this.deleteLocalFiles.getSelection() && resource.getSyncState() == 6) {
                ++deleted;
            } else if ((selection == 0 || selection == 1) && this.deleteRemoteFiles.getSelection() && resource.getSyncState() == 7) {
                ++deleted;
            } else if (resource.getPair() != null) {
                ++updated;
            }
            ++n2;
        }
        this.updatedLabel.setText(MessageFormat.format(UPDATED_LABEL, updated));
        if (deleted == 0) {
            this.deletedLabel.setFont(this.updatedLabel.getFont());
            this.deletedLabel.setForeground(null);
        } else {
            if (this.boldFont == null) {
                FontData[] data = SWTUtils.boldFont((Font)this.deletedLabel.getFont());
                this.boldFont = new Font((Device)this.deletedLabel.getDisplay(), data);
                this.deletedLabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        SmartSyncDialog.this.boldFont.dispose();
                    }
                });
            }
            this.deletedLabel.setFont(this.boldFont);
            this.deletedLabel.setForeground(this.deletedLabel.getDisplay().getSystemColor(3));
        }
        this.deletedLabel.setText(MessageFormat.format(DELETED_LABEL, deleted));
        this.skippedLabel.setText(MessageFormat.format(SKIPPED_LABEL, skipped));
        this.skipped = skipped;
        this.skippedLabel.getParent().layout(true, true);
        this.startSync.setEnabled(deleted + updated > 0);
    }

    private void updateSyncArrows(int selection) {
        switch (selection) {
            case 0: {
                this.left_arrow.setSelection(true);
                this.right_arrow.setSelection(true);
                this.sync_label.setText(Messages.SmartSyncDialog_BothDirection);
                break;
            }
            case 1: 
            case 3: {
                this.left_arrow.setSelection(false);
                this.right_arrow.setSelection(true);
                this.sync_label.setText(Messages.SmartSyncDialog_Upload);
                break;
            }
            case 2: 
            case 4: {
                this.left_arrow.setSelection(true);
                this.right_arrow.setSelection(false);
                this.sync_label.setText(Messages.SmartSyncDialog_Download);
            }
        }
    }

    private Composite createTable(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        main.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 400;
        main.setLayoutData((Object)gridData);
        this.syncViewer = new SmartSyncViewer(main, this.end1, this.end2);
        this.syncViewer.setPresentationType(SmartSyncDialog.getPresentationTypePref());
        this.syncViewer.setShowDatesSelected(SmartSyncDialog.getShowModificationTimePref());
        this.syncViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (SmartSyncDialog.this.startSync.getText().equals(Messages.SmartSyncDialog_StartSync)) {
                    if (element instanceof Item) {
                        element = ((Item)element).getData();
                    }
                    ISyncResource resource = (ISyncResource)element;
                    resource.setSkipped(Boolean.parseBoolean(value.toString()));
                    SmartSyncDialog.this.syncViewer.update(element, null);
                    if (resource instanceof SyncFolder) {
                        Collection children = ((SyncFolder)resource).getAllChildren();
                        for (ISyncResource child : children) {
                            SmartSyncDialog.this.syncViewer.update(child, null);
                        }
                    }
                    if (!resource.isSkipped() && resource.getParent() != null) {
                        resource.getParent().setSkipped(false, false);
                        SmartSyncDialog.this.syncViewer.update(resource.getParent(), null);
                    }
                    SmartSyncDialog.this.updateStatLabels();
                }
            }

            public Object getValue(Object element, String property) {
                return ((ISyncResource)element).isSkipped();
            }

            public boolean canModify(Object element, String property) {
                return Messages.SmartSyncDialog_ColumnSkip.equals(property);
            }
        });
        this.viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof SyncFile || element instanceof SyncFolder) {
                    ISyncResource resource = (ISyncResource)element;
                    if (SmartSyncDialog.this.searchText == null) {
                        return true;
                    }
                    String path = resource.getPath().toString();
                    Matcher m = SmartSyncDialog.this.searchPattern.matcher(path);
                    return m.find();
                }
                return false;
            }
        };
        this.syncViewer.addFilter(this.viewerFilter);
        this.errorComp = this.createErrorSection(main);
        this.loadingComp = this.createLoadingSection(main);
        this.synced = this.createSyncedSection(main);
        return main;
    }

    private Composite createSyncedSection(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setBackgroundMode(1);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.exclude = true;
        main.setLayoutData((Object)gridData);
        this.syncedIcon = new Label(main, 0x1000000);
        this.syncedIcon.setImage(SyncingUIPlugin.getImage("icons/full/obj16/synced.png"));
        this.syncedIcon.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.syncedText = new Label(main, 0x1000040);
        final Font font = new Font((Device)main.getDisplay(), "Arial", 12, 0);
        this.syncedText.setFont(font);
        this.syncedText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.syncedText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.syncedText.setText(String.valueOf(this.end1) + " and " + this.end2 + Messages.SmartSyncDialog_InSync);
        main.setVisible(false);
        return main;
    }

    private Composite createLoadingSection(Composite parent) {
        Composite loadingComp = new Composite(parent, 0);
        loadingComp.setLayout((Layout)new GridLayout());
        loadingComp.setLayoutData((Object)new GridData(4, 4, true, false));
        loadingComp.setBackgroundMode(1);
        this.loadingLabel = new Label(loadingComp, 0);
        this.loadingLabel.setText(String.valueOf(SYNC_LABEL) + "...");
        this.loadingLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        ProgressBar loadingBar = new ProgressBar(loadingComp, 65538);
        loadingBar.setLayoutData((Object)new GridData(4, 4, true, false));
        return loadingComp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.startSync = this.createButton(parent, 10, Messages.SmartSyncDialog_StartSync, true);
        GridData gridData = new GridData(4, 0x1000008, false, false);
        GC gc = new GC((Drawable)this.startSync);
        gridData.widthHint = Math.max(gc.stringExtent((String)Messages.SmartSyncDialog_StartSync).x, gc.stringExtent((String)Messages.SmartSyncDialog_RunInBackground).x) + 50;
        gc.dispose();
        this.startSync.setLayoutData((Object)gridData);
        this.startSync.addSelectionListener((SelectionListener)this);
        this.saveLog = this.createButton(parent, 13, "Save Log...", false);
        this.saveLog.addSelectionListener((SelectionListener)this);
        this.saveLog.setEnabled(false);
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancel.addSelectionListener((SelectionListener)this);
    }

    private void setEnabled(boolean enabled) {
        boolean syncEnabled;
        this.directionBar.setEnabled(enabled);
        this.optionsBar.setEnabled(enabled);
        boolean bl = syncEnabled = enabled && this.syncViewer.getCurrentResources().length > 0;
        if (!this.startSync.isDisposed()) {
            this.startSync.setEnabled(syncEnabled);
        }
        if (enabled) {
            this.updateFileButtonsState();
            this.updateSyncArrows(this.directionBar.getSelection());
        }
    }

    public int open() {
        this.setBlockOnOpen(false);
        if (!this.compareInBackground) {
            super.open();
        }
        this.load(true);
        return 0;
    }

    private void load(final boolean showSyncedMessage) {
        boolean forceDown;
        boolean forceUp;
        if (!this.compareInBackground) {
            this.setEnabled(false);
            GridData data = (GridData)this.loadingComp.getLayoutData();
            data.exclude = false;
            this.loadingComp.setVisible(true);
            this.loadingComp.getParent().layout(true, true);
        }
        boolean bl = this.compareInBackground ? false : (forceUp = this.directionBar.getSelection() == 3);
        boolean bl2 = this.compareInBackground ? false : (forceDown = this.directionBar.getSelection() == 4);
        if (this.buildSmartSync != null) {
            this.buildSmartSync.cancel();
        }
        this.buildSmartSync = new Job("Generating Synchronize Status"){

            protected IStatus run(IProgressMonitor monitor) {
                SmartSyncDialog.this.syncer.setEventHandler((ISyncEventHandler)new SyncEventHandlerAdapterWithProgressMonitor(monitor){

                    public boolean syncEvent(final VirtualFileSyncPair item, int index, int totalItems, IProgressMonitor monitor) {
                        if (item != null && !SmartSyncDialog.this.compareInBackground) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (SmartSyncDialog.this.loadingLabel == null || SmartSyncDialog.this.loadingLabel.isDisposed()) {
                                        return;
                                    }
                                    String name = SmartSyncDialog.getFilename(item);
                                    if (name != null) {
                                        SmartSyncDialog.this.loadingLabel.setText(String.valueOf(SYNC_LABEL) + name);
                                        SmartSyncDialog.this.loadingLabel.getParent().layout(true, true);
                                    }
                                }
                            });
                        }
                        return super.syncEvent(item, index, totalItems, monitor);
                    }
                });
                VirtualFileSyncPair[] items = new VirtualFileSyncPair[]{};
                Exception error = null;
                try {
                    HashMap<String, VirtualFileSyncPair> pairs;
                    IFileStore[] clientFiles;
                    if (forceUp) {
                        IFileStore[] serverFiles;
                        clientFiles = SmartSyncDialog.this.sourceFilesToBeSynced == null ? EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.source, (boolean)true, (boolean)false, null) : EFSUtils.getAllFiles((IFileStore[])SmartSyncDialog.this.sourceFilesToBeSynced, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                        items = SmartSyncDialog.this.syncer.createSyncItems(clientFiles, new IFileStore[0], monitor);
                        pairs = new HashMap<String, VirtualFileSyncPair>();
                        VirtualFileSyncPair[] virtualFileSyncPairArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            VirtualFileSyncPair item = virtualFileSyncPairArray[n2];
                            pairs.put(item.getRelativePath(), item);
                            ++n2;
                        }
                        IFileStore[] iFileStoreArray = serverFiles = EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.dest, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                        int n3 = serverFiles.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IFileStore file = iFileStoreArray[n4];
                            VirtualFileSyncPair pair = (VirtualFileSyncPair)pairs.get(EFSUtils.getRelativePath((IFileStore)SmartSyncDialog.this.destConnectionPoint.getRoot(), (IFileStore)file, null));
                            if (pair != null) {
                                pair.setDestinationFile(file);
                                pair.setSyncState(4);
                            }
                            ++n4;
                        }
                    } else if (forceDown) {
                        IFileStore[] clientFiles2;
                        IFileStore[] serverFiles = SmartSyncDialog.this.destFilesToBeSynced == null ? EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.dest, (boolean)true, (boolean)false, null) : SyncUtils.getDownloadFiles(SmartSyncDialog.this.sourceConnectionPoint, SmartSyncDialog.this.destConnectionPoint, SmartSyncDialog.this.destFilesToBeSynced, false, true, monitor);
                        items = SmartSyncDialog.this.syncer.createSyncItems(new IFileStore[0], serverFiles, monitor);
                        pairs = new HashMap();
                        VirtualFileSyncPair[] virtualFileSyncPairArray = items;
                        int file = items.length;
                        int pair = 0;
                        while (pair < file) {
                            VirtualFileSyncPair item = virtualFileSyncPairArray[pair];
                            pairs.put(item.getRelativePath(), item);
                            ++pair;
                        }
                        IFileStore[] iFileStoreArray = clientFiles2 = EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.source, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                        int n = clientFiles2.length;
                        int n5 = 0;
                        while (n5 < n) {
                            IFileStore file2 = iFileStoreArray[n5];
                            VirtualFileSyncPair pair2 = (VirtualFileSyncPair)pairs.get(Synchronizer.getCanonicalPath((IFileStore)SmartSyncDialog.this.sourceConnectionPoint.getRoot(), (IFileStore)file2));
                            if (pair2 != null) {
                                pair2.setSourceFile(file2);
                                pair2.setSyncState(5);
                            }
                            ++n5;
                        }
                    } else if (SmartSyncDialog.this.sourceFilesToBeSynced == null && SmartSyncDialog.this.destFilesToBeSynced == null) {
                        items = SmartSyncDialog.this.syncer.getSyncItems(SmartSyncDialog.this.sourceConnectionPoint, SmartSyncDialog.this.destConnectionPoint, SmartSyncDialog.this.source, SmartSyncDialog.this.dest, monitor);
                    } else {
                        clientFiles = SmartSyncDialog.this.sourceFilesToBeSynced == null ? EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.source, (boolean)true, (boolean)false, null) : EFSUtils.getAllFiles((IFileStore[])SmartSyncDialog.this.sourceFilesToBeSynced, (boolean)true, (boolean)false, (IProgressMonitor)monitor);
                        IFileStore[] serverFiles = SmartSyncDialog.this.destFilesToBeSynced == null ? EFSUtils.getFiles((IFileStore)SmartSyncDialog.this.dest, (boolean)true, (boolean)false, null) : SyncUtils.getDownloadFiles(SmartSyncDialog.this.sourceConnectionPoint, SmartSyncDialog.this.destConnectionPoint, SmartSyncDialog.this.destFilesToBeSynced, false, true, monitor);
                        items = SmartSyncDialog.this.syncer.createSyncItems(clientFiles, serverFiles, monitor);
                    }
                }
                catch (OperationCanceledException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (Exception e1) {
                    IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (String)Messages.SmartSyncDialog_ErrorSmartSync, (Throwable)e1);
                    error = e1;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (items != null && error == null) {
                    SmartSyncDialog.this.root = SyncModelBuilder.buildSyncFolder((IConnectionPoint)SmartSyncDialog.this.sourceConnectionPoint, (IConnectionPoint)SmartSyncDialog.this.destConnectionPoint, (VirtualFileSyncPair[])items);
                    UIJob update = new UIJob("Loading Sync"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (SmartSyncDialog.this.compareInBackground) {
                                SmartSyncDialog.super.open();
                            }
                            if (SmartSyncDialog.this.loadingComp != null && !SmartSyncDialog.this.loadingComp.isDisposed()) {
                                GridData data = (GridData)SmartSyncDialog.this.loadingComp.getLayoutData();
                                data.exclude = true;
                                SmartSyncDialog.this.loadingComp.setVisible(false);
                                data = (GridData)SmartSyncDialog.this.errorComp.getLayoutData();
                                data.exclude = true;
                                SmartSyncDialog.this.errorComp.setVisible(false);
                                SmartSyncDialog.this.syncViewer.setInput(SmartSyncDialog.this.root);
                                if (SmartSyncDialog.this.syncViewer.getCurrentResources().length > 0) {
                                    data = (GridData)SmartSyncDialog.this.synced.getLayoutData();
                                    data.grabExcessVerticalSpace = true;
                                    data.exclude = true;
                                    SmartSyncDialog.this.synced.setVisible(false);
                                    data = (GridData)SmartSyncDialog.this.syncViewer.getTree().getLayoutData();
                                    data.exclude = false;
                                    SmartSyncDialog.this.syncViewer.setVisible(true);
                                    SmartSyncDialog.this.setEnabled(true);
                                    SmartSyncDialog.this.startSync.setFocus();
                                } else if (showSyncedMessage) {
                                    data = (GridData)SmartSyncDialog.this.syncViewer.getTree().getLayoutData();
                                    data.exclude = true;
                                    SmartSyncDialog.this.syncViewer.setVisible(false);
                                    data = (GridData)SmartSyncDialog.this.synced.getLayoutData();
                                    data.grabExcessVerticalSpace = true;
                                    data.exclude = false;
                                    SmartSyncDialog.this.synced.setVisible(true);
                                    SmartSyncDialog.this.cancel.setText(Messages.SmartSyncDialog_Close);
                                    SmartSyncDialog.this.setEnabled(true);
                                    SmartSyncDialog.this.syncer.disconnect();
                                } else {
                                    SmartSyncDialog.this.setEnabled(true);
                                }
                                SmartSyncDialog.this.swappable.getParent().layout(true, true);
                                SmartSyncDialog.this.updateStatLabels();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    update.schedule();
                } else {
                    final StringBuilder errorMessage = new StringBuilder();
                    if (error != null) {
                        if (error instanceof UnknownHostException) {
                            errorMessage.append(MessageFormat.format(Messages.SmartSyncDialog_UnknownHostError, SmartSyncDialog.this.end1, SmartSyncDialog.this.end2));
                        } else {
                            errorMessage.append(Messages.SmartSyncDialog_ErrorSync);
                            errorMessage.append("\n " + Messages.SmartSyncDialog_ErrorMessage + error.getMessage());
                        }
                    }
                    UIJob showError = new UIJob("Showing sync error"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (SmartSyncDialog.this.compareInBackground) {
                                SmartSyncDialog.super.open();
                            }
                            if (SmartSyncDialog.this.loadingComp != null && !SmartSyncDialog.this.loadingComp.isDisposed()) {
                                GridData data = (GridData)SmartSyncDialog.this.loadingComp.getLayoutData();
                                data.exclude = true;
                                SmartSyncDialog.this.loadingComp.setVisible(false);
                                data = (GridData)SmartSyncDialog.this.syncViewer.getTree().getLayoutData();
                                data.exclude = true;
                                SmartSyncDialog.this.syncViewer.setVisible(false);
                                data = (GridData)SmartSyncDialog.this.errorComp.getLayoutData();
                                data.exclude = false;
                                SmartSyncDialog.this.errorComp.setVisible(true);
                                SmartSyncDialog.this.errorLabel.setText(errorMessage.toString());
                                SmartSyncDialog.this.swappable.getParent().layout(true, true);
                                SmartSyncDialog.this.setEnabled(false);
                                SmartSyncDialog.this.syncer.disconnect();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    showError.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        this.buildSmartSync.setPriority(30);
        try {
            this.buildSmartSync.setSystem(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.buildSmartSync.schedule();
    }

    protected void dispose() {
        if (this.titleImage != null) {
            this.setTitleImage(null);
            this.titleImage.dispose();
            this.titleImage = null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = SyncingUIPlugin.getImageDescriptor("/icons/full/wizban/sync.png").createImage();
        this.dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SmartSyncDialog.this.dispose();
            }
        });
        this.setTitleImage(this.titleImage);
        this.getShell().setText("Synchronize");
        this.setTitle("Synchronize files between two endpoints");
        Composite displayArea = new Composite(this.dialogArea, 0);
        displayArea.setLayout((Layout)new GridLayout());
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHeader(displayArea);
        this.createMainSection(displayArea);
        this.createAdvancedSection(displayArea);
        this.syncViewer.setSyncDirection(this.directionBar.getSelection());
        return this.dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        this.setEnabled(false);
        this.updateDeleteStates();
        if (this.getShell() != null && this.getParentShell() != null) {
            SWTUtils.center((Shell)this.getShell(), (Shell)this.getParentShell());
        }
        return composite;
    }

    public void setHandler(ISyncEventHandler handler) {
        this.handler = handler;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.deleteLocalFiles) {
            SmartSyncDialog.saveDeleteLocalPreference(this.deleteLocalFiles.getSelection());
            this.updateDeleteStates();
        } else if (source == this.deleteRemoteFiles) {
            SmartSyncDialog.saveDeleteRemotePreference(this.deleteRemoteFiles.getSelection());
            this.updateDeleteStates();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.closeWhenDone) {
            SmartSyncDialog.getSyncingPreferenceStore().setValue(CLOSE_WHEN_DONE, this.closeWhenDone.getSelection());
        } else if (source == this.useCrc) {
            SmartSyncDialog.getCoreUIPreferenceStore().setValue(USE_CRC, this.useCrc.getSelection());
        } else if (source == this.syncInBackground) {
            SmartSyncDialog.getCoreUIPreferenceStore().setValue(COMPARE_IN_BACKGROUND, this.syncInBackground.getSelection());
        } else if (source == this.retryLink) {
            this.load(true);
        } else if (source == this.startSync) {
            this.savePermissions();
            String text = this.startSync.getText();
            if (text.equals(Messages.SmartSyncDialog_StartSync)) {
                this.startSync.setText(Messages.SmartSyncDialog_RunInBackground);
                this.startSync.getParent().layout();
                this.startSync();
            } else if (text.equals(Messages.SmartSyncDialog_RunInBackground)) {
                this.setReturnCode(1);
                this.close();
            }
        } else if (source == this.saveLog) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            IDialogSettings editorSettings = SyncingUIPlugin.getDefault().getDialogSettings();
            String value = editorSettings.get(LOG_EXPORT_DIRECTORY);
            if (value != null) {
                fileDialog.setFilterPath(value);
            }
            SimpleDateFormat fileFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            Date d = new Date();
            fileDialog.setFileName("Aptana Synchronize Log " + fileFormat.format(d) + ".txt");
            String path = fileDialog.open();
            if (path == null) {
                return;
            }
            File logFile = new File(path);
            editorSettings.put(LOG_EXPORT_DIRECTORY, logFile.getParent());
            SyncExporter exporter = new SyncExporter();
            ISyncResource[] resources = this.syncViewer.getCurrentResources();
            exporter.export(logFile, resources);
        }
    }

    private void savePermissions() {
        PreferenceUtils.setUpdatePermissions((boolean)this.uploadPermComposite.getUpdatePermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setSpecificPermissions((boolean)this.uploadPermComposite.getSpecificPermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setFilePermissions((long)this.uploadPermComposite.getFilePermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setFolderPermissions((long)this.uploadPermComposite.getFolderPermissions(), (PermissionDirection)PermissionDirection.UPLOAD);
        PreferenceUtils.setUpdatePermissions((boolean)this.downloadPermComposite.getUpdatePermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setSpecificPermissions((boolean)this.downloadPermComposite.getSpecificPermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setFilePermissions((long)this.downloadPermComposite.getFilePermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
        PreferenceUtils.setFolderPermissions((long)this.downloadPermComposite.getFolderPermissions(), (PermissionDirection)PermissionDirection.DOWNLOAD);
    }

    public void modifyText(ModifyEvent e) {
    }

    public void selectionChanged(int direction, boolean reload) {
        this.updateFileButtonsState();
        this.updateSyncArrows(this.directionBar.getSelection());
        this.syncViewer.setSyncDirection(this.directionBar.getSelection());
        SmartSyncDialog.saveDirectionPref(direction);
        if (reload) {
            this.load(false);
        } else {
            this.syncViewer.refreshAndExpandTo(2);
        }
    }

    public void stateChanged(int type) {
        this.syncViewer.setPresentationType(type);
        SmartSyncDialog.savePresentationTypePref(type);
    }

    public void showDatesSelected(boolean show) {
        this.syncViewer.setShowDatesSelected(show);
        SmartSyncDialog.saveShowModificationTimePref(show);
    }

    public void syncItem(final VirtualFileSyncPair item) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISyncResource resource = SmartSyncDialog.this.root.find(item);
                if (resource != null) {
                    resource.setTransferState(2);
                    if (SmartSyncDialog.this.dialogArea != null && !SmartSyncDialog.this.dialogArea.isDisposed()) {
                        SmartSyncDialog.this.syncViewer.showProgress(item);
                    }
                }
            }
        });
    }

    public void syncProgress(final VirtualFileSyncPair item, final long bytes) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISyncResource resource = SmartSyncDialog.this.root.find(item);
                if (resource != null) {
                    resource.setTransferredBytes(bytes);
                    if (SmartSyncDialog.this.dialogArea != null && !SmartSyncDialog.this.dialogArea.isDisposed()) {
                        SmartSyncDialog.this.syncViewer.update(resource, null);
                    }
                }
            }
        });
    }

    public void syncDone(final VirtualFileSyncPair item, boolean allDone) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISyncResource resource = SmartSyncDialog.this.root.find(item);
                if (resource != null) {
                    resource.setTransferState(0);
                    if (SmartSyncDialog.this.dialogArea != null && !SmartSyncDialog.this.dialogArea.isDisposed()) {
                        SmartSyncDialog.this.syncViewer.update(resource, null);
                        SmartSyncDialog.this.syncViewer.reveal(resource);
                    }
                }
            }
        });
        if (allDone) {
            this.syncJobDone();
        }
    }

    public void syncError(final VirtualFileSyncPair item, boolean allDone) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ISyncResource resource = SmartSyncDialog.this.root.find(item);
                if (resource != null) {
                    resource.setTransferState(1);
                    if (SmartSyncDialog.this.syncViewer != null && !SmartSyncDialog.this.syncViewer.getTree().isDisposed()) {
                        SmartSyncDialog.this.syncViewer.update(resource, null);
                        SmartSyncDialog.this.syncViewer.reveal(resource);
                    }
                }
            }
        });
        if (allDone) {
            this.syncJobDone();
        }
    }

    private void startSync() {
        ISyncResource[] resources;
        this.directionBar.setEnabled(false);
        this.optionsBar.setEnabled(false);
        this.right_arrow.setEnabled(false);
        this.left_arrow.setEnabled(false);
        ArrayList<VirtualFileSyncPair> pairs = new ArrayList<VirtualFileSyncPair>();
        ISyncResource[] iSyncResourceArray = resources = this.syncViewer.getCurrentResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ISyncResource resource = iSyncResourceArray[n2];
            VirtualFileSyncPair pair = resource.getPair();
            if (!resource.isSkipped() && pair != null) {
                pairs.add(pair);
            }
            ++n2;
        }
        boolean deleteLocal = this.deleteLocalFiles.getEnabled() && this.deleteLocalFiles.getSelection();
        boolean deleteRemote = this.deleteRemoteFiles.getEnabled() && this.deleteRemoteFiles.getSelection();
        this.deleteRemoteFiles.setEnabled(false);
        this.deleteLocalFiles.setEnabled(false);
        int direction = -1;
        int selection = this.directionBar.getSelection();
        if (selection == 2 || selection == 4) {
            direction = 2;
        } else if (selection == 1 || selection == 3) {
            direction = 1;
        } else if (selection == 0) {
            direction = 0;
        }
        if (this.syncJob != null) {
            this.syncJob.cancel();
        }
        this.syncJob = new SyncJob(this.syncer, pairs, direction, deleteRemote, deleteLocal, (SyncJob.Client)this, MessageFormat.format(Messages.SmartSyncDialog_Endpoints, this.end1, this.end2));
        this.syncJob.schedule();
    }

    private void syncJobDone() {
        if (this.handler != null) {
            this.handler.syncDone(null, null);
        }
        if (this.source != null && this.dest != null) {
            String comment = "";
            SmartSyncEventManager.getManager().fireEvent(this.syncJob.getCompletedPairs(), this.sourceConnectionPoint, this.destConnectionPoint, comment);
        }
        UIJob updateEndJob = new UIJob("Updating sync"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (SmartSyncDialog.this.closeWhenDone != null && !SmartSyncDialog.this.closeWhenDone.isDisposed()) {
                    if (SmartSyncDialog.this.closeWhenDone.getSelection()) {
                        SmartSyncDialog.this.setReturnCode(1);
                        SmartSyncDialog.this.disconnectAndClose();
                    } else {
                        GridData data;
                        SmartSyncDialog.this.cancel.setText(Messages.SmartSyncDialog_Close);
                        SmartSyncDialog.this.startSync.setEnabled(false);
                        int errorCount = SmartSyncDialog.this.syncJob.getErrorCount();
                        if (errorCount == 0) {
                            if (SmartSyncDialog.this.skipped > 0) {
                                SmartSyncDialog.this.syncedText.setText(String.valueOf(SmartSyncDialog.this.end1) + " and " + SmartSyncDialog.this.end2 + Messages.SmartSyncDialog_InSync + "\n " + Messages.SmartSyncDialog_SkippedFilesInSync);
                            }
                        } else {
                            data = (GridData)SmartSyncDialog.this.syncedIcon.getLayoutData();
                            data.exclude = true;
                            SmartSyncDialog.this.syncedIcon.setVisible(false);
                            SmartSyncDialog.this.syncedText.setText(String.valueOf(errorCount) + Messages.SmartSyncDialog_SyncError);
                        }
                        data = (GridData)SmartSyncDialog.this.synced.getLayoutData();
                        data.exclude = false;
                        SmartSyncDialog.this.synced.setVisible(true);
                        SmartSyncDialog.this.setEnabled(false);
                        SmartSyncDialog.this.swappable.layout(true, true);
                        SmartSyncDialog.this.right_arrow.setEnabled(true);
                        SmartSyncDialog.this.left_arrow.setEnabled(true);
                        SmartSyncDialog.this.saveLog.setEnabled(true);
                    }
                } else {
                    SmartSyncDialog.this.syncer.disconnect();
                }
                this.refresh(monitor);
                return Status.OK_STATUS;
            }

            private void refresh(IProgressMonitor monitor) {
                IViewPart viewPart;
                IConnectionPoint clientConnection = SmartSyncDialog.this.syncer.getClientFileManager();
                if (clientConnection instanceof WorkspaceConnectionPoint) {
                    IContainer resource = ((WorkspaceConnectionPoint)clientConnection).getResource();
                    IViewPart viewPart2 = UIUtils.findView((String)"org.eclipse.ui.navigator.ProjectExplorer");
                    if (viewPart2 instanceof CommonNavigator) {
                        CommonViewer viewer = ((CommonNavigator)viewPart2).getCommonViewer();
                        viewer.refresh((Object)resource);
                    }
                }
                IConnectionPoint serverConnection = SmartSyncDialog.this.syncer.getServerFileManager();
                ConnectionPointType type = CoreIOPlugin.getConnectionPointManager().getType(serverConnection);
                if (type != null && type.getCategory().isRemote() && (viewPart = UIUtils.findView((String)"com.aptana.ui.io.remoteview")) instanceof RemoteNavigatorView) {
                    RemoteNavigatorView view = (RemoteNavigatorView)viewPart;
                    view.getCommonViewer().refresh((Object)serverConnection);
                }
            }
        };
        EclipseUtil.setSystemForJob((Job)updateEndJob);
        updateEndJob.schedule();
    }

    private void updateDeleteStates() {
        this.syncViewer.setDeleteLocalFiles(this.deleteLocalFiles.getSelection());
        this.syncViewer.setDeleteRemoteFiles(this.deleteRemoteFiles.getSelection());
        this.updateStatLabels();
        boolean syncEnabled = this.syncViewer.getCurrentResources().length > 0;
        this.startSync.setEnabled(syncEnabled);
    }

    private void updateFileButtonsState() {
        int selection = this.directionBar.getSelection();
        switch (selection) {
            case 1: {
                this.deleteLocalFiles.setEnabled(false);
                this.deleteRemoteFiles.setEnabled(true);
                break;
            }
            case 2: {
                this.deleteLocalFiles.setEnabled(true);
                this.deleteRemoteFiles.setEnabled(false);
                break;
            }
            case 3: 
            case 4: {
                this.deleteLocalFiles.setEnabled(false);
                this.deleteRemoteFiles.setEnabled(false);
                break;
            }
            default: {
                this.deleteRemoteFiles.setEnabled(true);
                this.deleteLocalFiles.setEnabled(true);
            }
        }
    }

    private void cancel() {
        if (this.buildSmartSync != null) {
            this.buildSmartSync.cancel();
        }
        if (this.syncJob != null) {
            this.syncJob.cancel();
        }
        this.disconnectAndClose();
    }

    private static String getFilename(VirtualFileSyncPair item) {
        if (item.getDestinationFile() != null) {
            return item.getDestinationFile().getName();
        }
        if (item.getSourceFile() != null) {
            return item.getSourceFile().getName();
        }
        return null;
    }

    private static IPreferenceStore getCoreUIPreferenceStore() {
        return UIPlugin.getDefault().getPreferenceStore();
    }

    private static IPreferenceStore getSyncingPreferenceStore() {
        return SyncingUIPlugin.getDefault().getPreferenceStore();
    }

    private static int getPresentationTypePref() {
        String viewPref = SmartSyncDialog.getSyncingPreferenceStore().getString("VIEW_MODE");
        if ("TREE".equals(viewPref)) {
            return 1;
        }
        return 0;
    }

    private static int getDirectionPref() {
        String directionPref = SmartSyncDialog.getSyncingPreferenceStore().getString("DIRECTION_MODE");
        if ("BOTH".equals(directionPref)) {
            return 0;
        }
        if ("UPLOAD".equals(directionPref)) {
            return 1;
        }
        if ("DOWNLOAD".equals(directionPref)) {
            return 2;
        }
        if ("FORCE_UPLOAD".equals(directionPref)) {
            return 3;
        }
        return 4;
    }

    private static boolean getDeleteLocalPreference() {
        return SmartSyncDialog.getSyncingPreferenceStore().getBoolean("DELETE_LOCAL_FILES");
    }

    private static boolean getDeleteRemotePreference() {
        return SmartSyncDialog.getSyncingPreferenceStore().getBoolean("DELETE_REMOTE_FILES");
    }

    private static boolean getShowModificationTimePref() {
        return SmartSyncDialog.getSyncingPreferenceStore().getBoolean("SHOW_MODIFICATION_TIME");
    }

    private static void savePresentationTypePref(int type) {
        IPreferenceStore prefs = SmartSyncDialog.getSyncingPreferenceStore();
        switch (type) {
            case 0: {
                prefs.setValue("VIEW_MODE", "FLAT");
                break;
            }
            case 1: {
                prefs.setValue("VIEW_MODE", "TREE");
            }
        }
    }

    private static void saveDirectionPref(int direction) {
        IPreferenceStore prefs = SmartSyncDialog.getSyncingPreferenceStore();
        switch (direction) {
            case 0: {
                prefs.setValue("DIRECTION_MODE", "BOTH");
                break;
            }
            case 1: {
                prefs.setValue("DIRECTION_MODE", "UPLOAD");
                break;
            }
            case 2: {
                prefs.setValue("DIRECTION_MODE", "DOWNLOAD");
                break;
            }
            case 3: {
                prefs.setValue("DIRECTION_MODE", "FORCE_UPLOAD");
                break;
            }
            case 4: {
                prefs.setValue("DIRECTION_MODE", "FORCE_DOWNLOAD");
            }
        }
    }

    private static void saveDeleteLocalPreference(boolean selected) {
        SmartSyncDialog.getSyncingPreferenceStore().setValue("DELETE_LOCAL_FILES", selected);
    }

    private static void saveDeleteRemotePreference(boolean selected) {
        SmartSyncDialog.getSyncingPreferenceStore().setValue("DELETE_REMOTE_FILES", selected);
    }

    private static void saveShowModificationTimePref(boolean selected) {
        SmartSyncDialog.getSyncingPreferenceStore().setValue("SHOW_MODIFICATION_TIME", selected);
    }

    public void search(String text, boolean isCaseSensitive, boolean isRegularExpression) {
        this.searchText = text;
        this.searchPattern = this.searchComposite.createSearchPattern();
        this.syncViewer.refresh();
    }

    private static class LabelToolTip
    extends ToolTip {
        private IConnectionPoint connectionPoint;
        private IFileStore[] files;

        LabelToolTip(Control control, IConnectionPoint connectionPoint, IFileStore[] files) {
            super(control, 2, false);
            this.connectionPoint = connectionPoint;
            this.files = files;
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            Text text;
            Composite contentArea = new Composite(parent, 0);
            contentArea.setLayout((Layout)new GridLayout());
            StringBuilder buf = new StringBuilder();
            IFileStore[] iFileStoreArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore file = iFileStoreArray[n2];
                buf.append(EFSUtils.getRelativePath((IConnectionPoint)this.connectionPoint, (IFileStore)file, null));
                buf.append('\n');
                ++n2;
            }
            GridData gridData = new GridData(4, 4, true, true);
            GC gc = new GC((Drawable)contentArea);
            if (gc.textExtent((String)buf.toString()).y > 200) {
                text = new Text(contentArea, 522);
                gridData.heightHint = 200;
            } else {
                text = new Text(contentArea, 10);
            }
            gc.dispose();
            text.setLayoutData((Object)gridData);
            text.setText(buf.toString());
            return contentArea;
        }
    }
}

